/*
 * Decompiled with CFR 0.152.
 */
package com.bitmester.ui;

import com.bitmester.model.PictureInfo;
import com.bitmester.model.Plus4Palette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.IntConsumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class RemapColorBandsDialog
extends JDialog {
    private final PictureInfo pic;
    private final JPanel list;
    private final Runnable beforeApply;

    public RemapColorBandsDialog(Window owner, PictureInfo pic) {
        this(owner, pic, null);
    }

    public RemapColorBandsDialog(Window owner, PictureInfo pic, Runnable beforeApply) {
        super(owner, "Remap Color Bands", Dialog.ModalityType.APPLICATION_MODAL);
        this.pic = pic;
        this.beforeApply = beforeApply;
        this.list = new JPanel();
        this.list.setLayout(new BoxLayout(this.list, 1));
        this.list.setBorder(new EmptyBorder(4, 8, 8, 8));
        for (int y = 0; y < 200; ++y) {
            Row row = new Row(y);
            this.list.add(row);
            this.list.add(Box.createVerticalStrut(2));
        }
        JScrollPane scroll = new JScrollPane(this.list, 22, 32);
        scroll.getVerticalScrollBar().setUnitIncrement(96);
        scroll.getVerticalScrollBar().setBlockIncrement(288);
        JPanel header = new JPanel(new FlowLayout(0, 4, 4));
        JLabel hRow = new JLabel("Rows");
        Dimension rowDim = new Dimension(55, hRow.getPreferredSize().height);
        hRow.setPreferredSize(rowDim);
        JLabel hBg = new JLabel("BG $FF15");
        JLabel hMc = new JLabel("MC $FF16");
        hBg.setBorder(new EmptyBorder(0, 10, 0, 10));
        hMc.setBorder(new EmptyBorder(0, 17, 0, 8));
        JLabel hFF14Row = new JLabel("FF14 rows");
        hFF14Row.setBorder(new EmptyBorder(0, 20, 0, 30));
        JLabel hCols = new JLabel("FF14 columns");
        header.setBorder(new EmptyBorder(4, 8, 0, 8));
        header.add(hRow);
        header.add(hBg);
        header.add(hMc);
        header.add(hFF14Row);
        header.add(hCols);
        JPanel south = new JPanel(new BorderLayout(8, 8));
        JPanel selPanel = new JPanel(new FlowLayout(0, 8, 4));
        JButton btnAll = new JButton("Select all");
        JButton btnNone = new JButton("Unselect all");
        JButton btnFF15 = new JButton("Select all ff15");
        JButton btnFF16 = new JButton("Select all ff16");
        JButton btnAux0 = new JButton("Select all aux0");
        JButton btnAux1 = new JButton("Select all aux1");
        selPanel.add(btnAll);
        selPanel.add(btnNone);
        selPanel.add(btnFF15);
        selPanel.add(btnFF16);
        selPanel.add(btnAux0);
        selPanel.add(btnAux1);
        JPanel okPanel = new JPanel(new FlowLayout(2, 8, 4));
        JButton cancel = new JButton("Cancel");
        JButton apply = new JButton("Apply");
        okPanel.add(cancel);
        okPanel.add(apply);
        south.add((Component)selPanel, "West");
        south.add((Component)okPanel, "East");
        JPanel root = new JPanel(new BorderLayout(8, 4));
        root.add((Component)header, "North");
        root.add((Component)scroll, "Center");
        root.add((Component)south, "South");
        this.setContentPane(root);
        this.setPreferredSize(new Dimension(1300, 800));
        this.pack();
        this.setLocationRelativeTo(owner);
        cancel.addActionListener(e -> this.dispose());
        apply.addActionListener(e -> {
            if (beforeApply != null) {
                beforeApply.run();
            }
            for (Component c : this.list.getComponents()) {
                if (!(c instanceof Row)) continue;
                ((Row)c).commitToPicture();
            }
            this.dispose();
        });
        btnAll.addActionListener(e -> this.setAllSelection(true));
        btnNone.addActionListener(e -> this.setAllSelection(false));
        btnFF15.addActionListener(e -> this.setSelectionFF(true, false));
        btnFF16.addActionListener(e -> this.setSelectionFF(false, true));
        btnAux0.addActionListener(e -> this.setSelectionAuxSlot(0, true));
        btnAux1.addActionListener(e -> this.setSelectionAuxSlot(1, true));
    }

    private void setAllSelection(boolean sel) {
        for (Component c : this.list.getComponents()) {
            if (!(c instanceof Row)) continue;
            Row row = (Row)c;
            row.ff.selectAll(sel);
            row.aux.selectAll(sel);
        }
    }

    private void setSelectionFF(boolean ff15Sel, boolean ff16Sel) {
        for (Component c : this.list.getComponents()) {
            if (!(c instanceof Row)) continue;
            Row row = (Row)c;
            if (ff15Sel) {
                row.ff.setFF15Selected(true);
            }
            if (!ff16Sel) continue;
            row.ff.setFF16Selected(true);
        }
    }

    private void setSelectionAuxSlot(int slot, boolean sel) {
        int wanted = slot & 1;
        for (Component c : this.list.getComponents()) {
            if (!(c instanceof Row)) continue;
            Row row = (Row)c;
            if (row.aux.getSlot() != wanted) continue;
            row.aux.selectAll(sel);
        }
    }

    private static String hex2(int v) {
        return String.format("$%02X", v & 0xFF);
    }

    private static int clampY(int y) {
        return Math.max(0, Math.min(199, y));
    }

    private static int choosePalette(int initial) {
        final JDialog dlg = new JDialog((Window)null, "Choose Plus/4 color", Dialog.ModalityType.APPLICATION_MODAL);
        JPanel grid = new JPanel(new GridLayout(8, 16, 2, 2));
        grid.setBorder(new EmptyBorder(8, 8, 8, 8));
        final int[] result = new int[]{-1};
        int total = Plus4Palette.size();
        int i = 0;
        while (i < total) {
            JPanel cell = new JPanel();
            cell.setBackground(Plus4Palette.getColor(i));
            cell.setPreferredSize(new Dimension(16, 14));
            cell.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            final int idx = i++;
            cell.setToolTipText(String.format("#%d (%s)", idx, RemapColorBandsDialog.hex2(idx)));
            cell.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    result[0] = idx;
                    dlg.dispose();
                }
            });
            grid.add(cell);
        }
        JPanel south = new JPanel(new FlowLayout(2, 8, 8));
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(e -> {
            result[0] = -1;
            dlg.dispose();
        });
        south.add(cancel);
        dlg.setLayout(new BorderLayout());
        dlg.add((Component)grid, "Center");
        dlg.add((Component)south, "South");
        dlg.pack();
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
        return result[0];
    }

    private class Row
    extends JPanel {
        private final int y;
        private final FFStrip ff;
        private final AuxStrip aux;

        Row(int y) {
            super(new BorderLayout());
            this.y = y;
            this.ff = new FFStrip(y);
            boolean auxIsSlot0 = y % 2 == 0;
            this.aux = new AuxStrip(y, auxIsSlot0 ? 0 : 1);
            JLabel rowLbl = new JLabel(String.format("%03d", y));
            Dimension rowDim = new Dimension(55, rowLbl.getPreferredSize().height);
            rowLbl.setPreferredSize(rowDim);
            int ff14Row = y / 2 * 2;
            JLabel ff14Lbl = new JLabel(String.format("%02d", ff14Row));
            ff14Lbl.setBorder(new EmptyBorder(0, 16, 0, 16));
            JPanel line = new JPanel(new FlowLayout(0, 4, 0));
            line.add(rowLbl);
            line.add(this.ff);
            line.add(ff14Lbl);
            line.add(this.aux);
            MatteBorder topLine = y % 2 == 0 && y > 0 ? BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY) : BorderFactory.createMatteBorder(0, 0, 0, 0, Color.LIGHT_GRAY);
            EmptyBorder pad = new EmptyBorder(2, 2, 2, 2);
            this.setBorder(new CompoundBorder(topLine, pad));
            this.add((Component)line, "Center");
        }

        void commitToPicture() {
            this.ff.commitToPicture();
            this.aux.commitToPicture();
        }
    }

    private class FFStrip
    extends JPanel {
        private final int y;
        private final JCheckBox cbFF15;
        private final Swatch ff15Sw;
        private final JCheckBox cbFF16;
        private final Swatch ff16Sw;

        FFStrip(int y) {
            super(new FlowLayout(0, 4, 0));
            this.y = RemapColorBandsDialog.clampY(y);
            int idxFF15 = RemapColorBandsDialog.this.pic.getFF15Line()[this.y] & 0xFF;
            int idxFF16 = RemapColorBandsDialog.this.pic.getFF16Line()[this.y] & 0xFF;
            this.ff15Sw = new Swatch(idxFF15, null);
            this.cbFF15 = new JCheckBox("ff15", true);
            this.ff16Sw = new Swatch(idxFF16, null);
            this.cbFF16 = new JCheckBox("ff16", true);
            this.add(this.cbFF15);
            this.add(this.ff15Sw);
            this.add(Box.createHorizontalStrut(8));
            this.add(this.cbFF16);
            this.add(this.ff16Sw);
        }

        void commitToPicture() {
            if (this.cbFF15.isSelected()) {
                RemapColorBandsDialog.this.pic.getFF15Line()[this.y] = (byte)(this.ff15Sw.getIndex() & 0xFF);
            }
            if (this.cbFF16.isSelected()) {
                RemapColorBandsDialog.this.pic.getFF16Line()[this.y] = (byte)(this.ff16Sw.getIndex() & 0xFF);
            }
        }

        void selectAll(boolean sel) {
            this.cbFF15.setSelected(sel);
            this.cbFF16.setSelected(sel);
        }

        void setFF15Selected(boolean sel) {
            this.cbFF15.setSelected(sel);
        }

        void setFF16Selected(boolean sel) {
            this.cbFF16.setSelected(sel);
        }
    }

    private class AuxStrip
    extends JPanel {
        private final int y;
        private final int slot;
        private final AuxCell[] cells;

        AuxStrip(int y, int slot) {
            super(new FlowLayout(0, 2, 0));
            this.cells = new AuxCell[40];
            this.y = RemapColorBandsDialog.clampY(y);
            this.slot = slot & 1;
            JLabel lblSlot = new JLabel(slot == 0 ? "aux0" : "aux1");
            lblSlot.setBorder(new EmptyBorder(0, 8, 0, 8));
            this.add(lblSlot);
            for (int xc = 0; xc < 40; ++xc) {
                AuxCell c;
                int px = xc * 4;
                int present = RemapColorBandsDialog.this.pic.getAuxColorsAt(px, this.y)[this.slot] & 0xFF;
                this.cells[xc] = c = new AuxCell(xc, present);
                this.add(c);
            }
        }

        int getSlot() {
            return this.slot;
        }

        void selectAll(boolean sel) {
            for (AuxCell c : this.cells) {
                if (c == null) continue;
                c.setSelected(sel);
            }
        }

        void commitToPicture() {
            int band = this.y % 8 / 2;
            int rowPair = this.y / 8;
            int yBase = rowPair * 8 + band * 2;
            int yA = RemapColorBandsDialog.clampY(yBase);
            int yB = RemapColorBandsDialog.clampY(yBase + 1);
            for (int xc = 0; xc < 40; ++xc) {
                AuxCell cell = this.cells[xc];
                if (cell == null || !cell.isSelected()) continue;
                int px = xc * 4;
                int idx = cell.getIndex();
                RemapColorBandsDialog.this.pic.setAuxColorAt(px, yA, this.slot, idx);
                RemapColorBandsDialog.this.pic.setAuxColorAt(px, yB, this.slot, idx);
            }
        }
    }

    private static class Swatch
    extends JPanel {
        private int index;
        private final IntConsumer onPick;

        Swatch(int idx, IntConsumer onPick) {
            this.index = idx & 0xFF;
            this.onPick = onPick;
            this.setPreferredSize(new Dimension(24, 18));
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            this.setBackground(Plus4Palette.getColor(this.index));
            this.setToolTipText(RemapColorBandsDialog.hex2(this.index));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int sel = RemapColorBandsDialog.choosePalette(index);
                    if (sel >= 0) {
                        this.setIndex(sel);
                    }
                }
            });
        }

        void setIndex(int idx) {
            this.index = idx & 0xFF;
            this.setBackground(Plus4Palette.getColor(this.index));
            this.setToolTipText(RemapColorBandsDialog.hex2(this.index));
            if (this.onPick != null) {
                this.onPick.accept(this.index);
            }
            this.repaint();
        }

        int getIndex() {
            return this.index;
        }
    }

    private static class AuxCell
    extends JPanel {
        private final JCheckBox cb;
        private final Swatch sw;

        AuxCell(int xChar, int initial) {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(new EmptyBorder(0, 2, 0, 2));
            JLabel cap = new JLabel(String.format("%02d", xChar));
            cap.setFont(cap.getFont().deriveFont(0, 14.0f));
            this.cb = new JCheckBox();
            JPanel topRow = new JPanel(new FlowLayout(1, 2, 0));
            topRow.setOpaque(false);
            topRow.add(cap);
            topRow.add(this.cb);
            this.add(topRow);
            this.add(Box.createVerticalStrut(2));
            this.sw = new Swatch(initial, null);
            this.sw.setAlignmentX(0.5f);
            this.add(this.sw);
            this.add(Box.createVerticalStrut(2));
        }

        int getIndex() {
            return this.sw.getIndex();
        }

        void setIndex(int idx) {
            this.sw.setIndex(idx);
        }

        boolean isSelected() {
            return this.cb.isSelected();
        }

        void setSelected(boolean sel) {
            this.cb.setSelected(sel);
        }
    }
}

