/*
 * Decompiled with CFR 0.152.
 */
package com.bitmester.ui;

import com.bitmester.model.PictureInfo;
import com.bitmester.model.Plus4Palette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.IntConsumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class RecolorBlockDialog
extends JDialog {
    private final PictureInfo pic;
    private final int baseX;
    private final int baseY;
    private final Runnable beforeApply;
    private final JCheckBox cbAux0 = new JCheckBox();
    private final JCheckBox cbAux1 = new JCheckBox();
    private final JCheckBox cbFF15r1 = new JCheckBox();
    private final JCheckBox cbFF16r1 = new JCheckBox();
    private final JCheckBox cbFF15r2 = new JCheckBox();
    private final JCheckBox cbFF16r2 = new JCheckBox();
    private final Swatch swAux0;
    private final Swatch swAux1;
    private final Swatch swFF15r1;
    private final Swatch swFF16r1;
    private final Swatch swFF15r2;
    private final Swatch swFF16r2;
    private final JLabel lblHexAux0 = new JLabel();
    private final JLabel lblHexAux1 = new JLabel();
    private final JLabel lblHexFF15r1 = new JLabel();
    private final JLabel lblHexFF16r1 = new JLabel();
    private final JLabel lblHexFF15r2 = new JLabel();
    private final JLabel lblHexFF16r2 = new JLabel();

    public RecolorBlockDialog(Window owner, PictureInfo pic, int bx, int by, Runnable beforeApply) {
        super(owner, "Recolor actual 4\u00d72 colorblock", Dialog.ModalityType.APPLICATION_MODAL);
        this.pic = pic;
        this.baseX = bx;
        this.baseY = by;
        this.beforeApply = beforeApply;
        int[] a = pic.getAuxColorsAt(bx, by);
        int aux0 = a[0] & 0xFF;
        int aux1 = a[1] & 0xFF;
        int ff15Row1 = pic.getFF15Line()[by] & 0xFF;
        int ff16Row1 = pic.getFF16Line()[by] & 0xFF;
        int ff15Row2 = by + 1 < pic.getYs() ? pic.getFF15Line()[by + 1] & 0xFF : ff15Row1;
        int ff16Row2 = by + 1 < pic.getYs() ? pic.getFF16Line()[by + 1] & 0xFF : ff16Row1;
        this.swAux0 = new Swatch(aux0, idx -> this.lblHexAux0.setText(this.hexLabel(idx)));
        this.swAux1 = new Swatch(aux1, idx -> this.lblHexAux1.setText(this.hexLabel(idx)));
        this.swFF15r1 = new Swatch(ff15Row1, idx -> this.lblHexFF15r1.setText(this.hexLabel(idx)));
        this.swFF16r1 = new Swatch(ff16Row1, idx -> this.lblHexFF16r1.setText(this.hexLabel(idx)));
        this.swFF15r2 = new Swatch(ff15Row2, idx -> this.lblHexFF15r2.setText(this.hexLabel(idx)));
        this.swFF16r2 = new Swatch(ff16Row2, idx -> this.lblHexFF16r2.setText(this.hexLabel(idx)));
        this.lblHexAux0.setText(this.hexLabel(aux0));
        this.lblHexAux1.setText(this.hexLabel(aux1));
        this.lblHexFF15r1.setText(this.hexLabel(ff15Row1));
        this.lblHexFF16r1.setText(this.hexLabel(ff16Row1));
        this.lblHexFF15r2.setText(this.hexLabel(ff15Row2));
        this.lblHexFF16r2.setText(this.hexLabel(ff16Row2));
        for (JLabel lab : new JLabel[]{this.lblHexAux0, this.lblHexAux1, this.lblHexFF15r1, this.lblHexFF16r1, this.lblHexFF15r2, this.lblHexFF16r2}) {
            lab.setHorizontalAlignment(2);
        }
        JPanel root = new JPanel(new BorderLayout(8, 8));
        root.setBorder(new EmptyBorder(8, 8, 8, 8));
        int x2 = this.baseX + 3;
        int y2 = this.baseY + 1;
        JLabel info = new JLabel(String.format("Recolor 4\u00d72 block at X=%d\u2013%d  Y=%d\u2013%d", this.baseX, x2, this.baseY, y2));
        info.setHorizontalAlignment(2);
        root.add((Component)info, "North");
        JPanel grid = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.anchor = 17;
        gc.fill = 0;
        Font rowFont = info.getFont().deriveFont(0, 13.0f);
        RecolorBlockDialog.addRow(grid, gc, 0, this.cbAux0, "AUX0", this.swAux0, this.lblHexAux0, rowFont);
        RecolorBlockDialog.addRow(grid, gc, 1, this.cbAux1, "AUX1", this.swAux1, this.lblHexAux1, rowFont);
        RecolorBlockDialog.addRow(grid, gc, 2, this.cbFF15r1, "FF15 row1", this.swFF15r1, this.lblHexFF15r1, rowFont);
        RecolorBlockDialog.addRow(grid, gc, 3, this.cbFF16r1, "FF16 row1", this.swFF16r1, this.lblHexFF16r1, rowFont);
        RecolorBlockDialog.addRow(grid, gc, 4, this.cbFF15r2, "FF15 row2", this.swFF15r2, this.lblHexFF15r2, rowFont);
        RecolorBlockDialog.addRow(grid, gc, 5, this.cbFF16r2, "FF16 row2", this.swFF16r2, this.lblHexFF16r2, rowFont);
        root.add((Component)grid, "Center");
        JPanel buttons = new JPanel(new FlowLayout(2, 8, 0));
        JButton btnCancel = new JButton("Cancel");
        JButton btnApply = new JButton("Apply");
        btnCancel.addActionListener(e -> this.dispose());
        btnApply.addActionListener(e -> this.applyAndClose());
        buttons.add(btnCancel);
        buttons.add(btnApply);
        root.add((Component)buttons, "South");
        this.setContentPane(root);
        this.pack();
        this.setMinimumSize(new Dimension(280, 280));
        this.setLocationRelativeTo(owner);
    }

    private static void addRow(JPanel grid, GridBagConstraints gc, int row, JCheckBox cb, String labelText, Swatch sw, JLabel hexLabel, Font f) {
        cb.setHorizontalAlignment(2);
        JLabel lab = new JLabel(labelText);
        lab.setFont(f);
        lab.setHorizontalAlignment(2);
        hexLabel.setFont(f);
        gc.gridx = 0;
        gc.gridy = row;
        gc.weightx = 0.0;
        grid.add((Component)cb, gc);
        gc.gridx = 1;
        gc.gridy = row;
        gc.weightx = 0.0;
        grid.add((Component)lab, gc);
        gc.gridx = 2;
        gc.gridy = row;
        gc.weightx = 0.0;
        grid.add((Component)sw, gc);
        gc.gridx = 3;
        gc.gridy = row;
        gc.weightx = 1.0;
        grid.add((Component)hexLabel, gc);
    }

    private String hexLabel(int idx) {
        return String.format("$%02X", idx & 0xFF);
    }

    private void applyAndClose() {
        int x;
        int y;
        int idx;
        if (this.beforeApply != null) {
            this.beforeApply.run();
        }
        int y1 = this.baseY;
        int y2 = this.baseY + 1;
        if (y1 < 0 || y1 >= this.pic.getYs()) {
            this.dispose();
            return;
        }
        if (this.cbAux0.isSelected()) {
            idx = this.swAux0.getIndex();
            for (y = y1; y <= y2 && y < 200; ++y) {
                for (x = this.baseX; x < this.baseX + 4 && x < 160; ++x) {
                    this.pic.setAuxColorAt(x, y, 0, idx);
                }
            }
        }
        if (this.cbAux1.isSelected()) {
            idx = this.swAux1.getIndex();
            for (y = y1; y <= y2 && y < 200; ++y) {
                for (x = this.baseX; x < this.baseX + 4 && x < 160; ++x) {
                    this.pic.setAuxColorAt(x, y, 1, idx);
                }
            }
        }
        if (this.cbFF15r1.isSelected()) {
            idx = this.swFF15r1.getIndex();
            if (y1 >= 0 && y1 < this.pic.getYs()) {
                this.pic.getFF15Line()[y1] = (byte)(idx & 0xFF);
            }
        }
        if (this.cbFF16r1.isSelected()) {
            idx = this.swFF16r1.getIndex();
            if (y1 >= 0 && y1 < this.pic.getYs()) {
                this.pic.getFF16Line()[y1] = (byte)(idx & 0xFF);
            }
        }
        if (this.cbFF15r2.isSelected() && y2 >= 0 && y2 < this.pic.getYs()) {
            idx = this.swFF15r2.getIndex();
            this.pic.getFF15Line()[y2] = (byte)(idx & 0xFF);
        }
        if (this.cbFF16r2.isSelected() && y2 >= 0 && y2 < this.pic.getYs()) {
            idx = this.swFF16r2.getIndex();
            this.pic.getFF16Line()[y2] = (byte)(idx & 0xFF);
        }
        this.dispose();
    }

    private static int choosePalette(Window parent, int initialIndex) {
        final JDialog dlg = new JDialog(parent, "Choose Plus/4 color", Dialog.ModalityType.APPLICATION_MODAL);
        JPanel grid = new JPanel(new GridLayout(8, 16, 2, 2));
        grid.setBorder(new EmptyBorder(8, 8, 8, 8));
        final int[] result = new int[]{-1};
        int total = Plus4Palette.size();
        int i = 0;
        while (i < total) {
            JPanel cell = new JPanel();
            cell.setBackground(Plus4Palette.getColor(i));
            cell.setPreferredSize(new Dimension(22, 18));
            cell.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            final int idx = i++;
            cell.setToolTipText(String.format("#%d (0x%02X)", idx, idx));
            cell.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    result[0] = idx;
                    dlg.dispose();
                }
            });
            grid.add(cell);
        }
        JPanel south = new JPanel(new FlowLayout(2, 8, 8));
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(e -> {
            result[0] = -1;
            dlg.dispose();
        });
        south.add(cancel);
        dlg.setLayout(new BorderLayout());
        dlg.add((Component)grid, "Center");
        dlg.add((Component)south, "South");
        dlg.pack();
        dlg.setLocationRelativeTo(parent);
        dlg.setVisible(true);
        return result[0];
    }

    private static class Swatch
    extends JPanel {
        private int index;
        private final IntConsumer onChange;

        Swatch(int idx, IntConsumer onChange) {
            this.index = idx & 0xFF;
            this.onChange = onChange;
            this.setPreferredSize(new Dimension(24, 16));
            this.setMaximumSize(new Dimension(24, 16));
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            this.setBackground(Plus4Palette.getColor(this.index));
            this.setToolTipText(String.format("Index: %d ($%02X)", this.index, this.index));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int sel = RecolorBlockDialog.choosePalette(SwingUtilities.getWindowAncestor(this), index);
                    if (sel >= 0) {
                        this.setIndex(sel);
                    }
                }
            });
        }

        void setIndex(int idx) {
            this.index = idx & 0xFF;
            this.setBackground(Plus4Palette.getColor(this.index));
            this.setToolTipText(String.format("Index: %d ($%02X)", this.index, this.index));
            this.repaint();
            if (this.onChange != null) {
                this.onChange.accept(this.index);
            }
        }

        int getIndex() {
            return this.index;
        }
    }
}

