/*
 * Decompiled with CFR 0.152.
 */
package com.bitmester.ui;

import com.bitmester.model.PictureInfo;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PaintColorPanel
extends JPanel {
    private final JRadioButton[] radios = new JRadioButton[4];

    public PaintColorPanel(PictureInfo pic, Listener listener) {
        this.setLayout(new GridLayout(0, 4, 6, 6));
        this.setBorder(BorderFactory.createTitledBorder("Paint channel (0..3)"));
        ButtonGroup g = new ButtonGroup();
        String[] labels = new String[]{"0 (FF15/bg)", "1 (FF14 aux1)", "2 (FF14 aux0)", "3 (FF16/mc1)"};
        for (int i = 0; i < 4; ++i) {
            int idx = i;
            this.radios[i] = new JRadioButton(labels[i]);
            if (i == pic.getCurrentPaint()) {
                this.radios[i].setSelected(true);
            }
            this.radios[i].addActionListener(e -> {
                pic.setCurrentPaint(idx);
                if (listener != null) {
                    listener.onPaintColorChanged(idx);
                }
            });
            g.add(this.radios[i]);
            this.add(this.radios[i]);
        }
    }

    public void setSelected(int idx) {
        if (idx >= 0 && idx < this.radios.length) {
            this.radios[idx].setSelected(true);
        }
    }

    public static interface Listener {
        public void onPaintColorChanged(int var1);
    }
}

