/*
 * Decompiled with CFR 0.152.
 */
package com.bitmester.ui;

import com.bitmester.model.PictureInfo;
import com.bitmester.model.Plus4Palette;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.function.IntConsumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ColorFilterDialog
extends JDialog {
    private final PictureInfo pic;
    private final Runnable beforeApply;
    private final int paletteSize;
    private final Color[] paletteColors;
    private final int blackIndex;
    private final int whiteIndex;
    private FilterType currentFilter = FilterType.BW;
    private int[] currentMap;
    private final PreviewPanel previewPanel;
    private final JRadioButton rbBW;
    private final JRadioButton rbGray;
    private final JRadioButton rbSepia;
    private final JRadioButton rbHybridBlue;
    private final JRadioButton rbHybridGreen;
    private final JRadioButton rbUserColors;
    private final JSlider bwThresholdSlider;
    private final JLabel bwValueLabel;
    private final JPanel filterSettingsCards;
    private static final int USER_COLOR_COUNT = 30;
    private final JCheckBox[] userChecks = new JCheckBox[30];
    private final Swatch[] userSwatches = new Swatch[30];

    public ColorFilterDialog(Window owner, PictureInfo pic, Runnable beforeApply) {
        super(owner, "Color Filter", Dialog.ModalityType.APPLICATION_MODAL);
        this.pic = pic;
        this.beforeApply = beforeApply;
        this.paletteSize = Plus4Palette.size();
        this.paletteColors = new Color[this.paletteSize];
        for (int i = 0; i < this.paletteSize; ++i) {
            this.paletteColors[i] = Plus4Palette.getColor(i);
        }
        this.blackIndex = this.findDarkestIndex();
        this.whiteIndex = this.findBrightestIndex();
        this.setLayout(new BorderLayout(8, 8));
        ((JComponent)this.getContentPane()).setBorder(new EmptyBorder(8, 8, 8, 8));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JLabel lblTitle = new JLabel("Color filters");
        lblTitle.setFont(lblTitle.getFont().deriveFont(1, 16.0f));
        lblTitle.setAlignmentX(0.0f);
        leftPanel.add(lblTitle);
        leftPanel.add(Box.createVerticalStrut(6));
        leftPanel.add(Box.createHorizontalStrut(309));
        ButtonGroup bg = new ButtonGroup();
        this.rbBW = new JRadioButton("Black & White with Threshold");
        this.rbGray = new JRadioButton("Grayscale");
        this.rbSepia = new JRadioButton("Sepia");
        this.rbHybridBlue = new JRadioButton("Hybrid Blue");
        this.rbHybridGreen = new JRadioButton("Hybrid Green");
        this.rbUserColors = new JRadioButton("User Colors");
        this.rbBW.setSelected(true);
        Font listFont = this.rbBW.getFont().deriveFont(0, 14.0f);
        this.rbBW.setFont(listFont);
        this.rbGray.setFont(listFont);
        this.rbSepia.setFont(listFont);
        this.rbHybridBlue.setFont(listFont);
        this.rbHybridGreen.setFont(listFont);
        this.rbUserColors.setFont(listFont);
        JPanel rbPanel = new JPanel();
        rbPanel.setLayout(new BoxLayout(rbPanel, 1));
        rbPanel.setAlignmentX(0.0f);
        rbPanel.add(this.rbBW);
        rbPanel.add(this.rbGray);
        rbPanel.add(this.rbSepia);
        rbPanel.add(this.rbHybridBlue);
        rbPanel.add(this.rbHybridGreen);
        rbPanel.add(this.rbUserColors);
        bg.add(this.rbBW);
        bg.add(this.rbGray);
        bg.add(this.rbSepia);
        bg.add(this.rbHybridBlue);
        bg.add(this.rbHybridGreen);
        bg.add(this.rbUserColors);
        leftPanel.add(rbPanel);
        leftPanel.add(Box.createVerticalStrut(8));
        this.filterSettingsCards = new JPanel(new CardLayout());
        this.filterSettingsCards.setBorder(BorderFactory.createTitledBorder("Filter settings"));
        JPanel bwPanel = new JPanel(new BorderLayout(4, 4));
        JPanel bwTop = new JPanel(new FlowLayout(0, 0, 0));
        bwTop.add(new JLabel("Threshold (0..255):"));
        this.bwThresholdSlider = new JSlider(0, 255, 128);
        this.bwThresholdSlider.setPreferredSize(new Dimension(160, 40));
        this.bwValueLabel = new JLabel("128");
        bwTop.add(this.bwThresholdSlider);
        bwTop.add(this.bwValueLabel);
        bwPanel.add((Component)bwTop, "North");
        this.filterSettingsCards.add((Component)bwPanel, FilterType.BW.name());
        JPanel grayPanel = new JPanel(new BorderLayout());
        grayPanel.add((Component)new JLabel("Grayscale: Palette column 2 + Black/White."), "North");
        this.filterSettingsCards.add((Component)grayPanel, FilterType.GRAYSCALE.name());
        JPanel sepiaPanel = new JPanel(new BorderLayout());
        sepiaPanel.add((Component)new JLabel("Sepia: Palette column 8 + Black."), "North");
        this.filterSettingsCards.add((Component)sepiaPanel, FilterType.SEPIA.name());
        JPanel hbPanel = new JPanel(new BorderLayout());
        hbPanel.add((Component)new JLabel("Hybrid Blue: Black + columns 7,14,15"), "North");
        this.filterSettingsCards.add((Component)hbPanel, FilterType.HYBRID_BLUE.name());
        JPanel hgPanel = new JPanel(new BorderLayout());
        hgPanel.add((Component)new JLabel("Hybrid Green: Black + columns 6,11,13,16"), "North");
        this.filterSettingsCards.add((Component)hgPanel, FilterType.HYBRID_GREEN.name());
        JPanel userPanel = new JPanel();
        userPanel.setLayout(new BorderLayout(4, 4));
        JLabel userInfo = new JLabel("User Colors: 30 slots (5\u00d76), checkbox + color.");
        userPanel.add((Component)userInfo, "North");
        JPanel userGrid = new JPanel(new GridLayout(5, 6, 4, 4));
        int palSz = Plus4Palette.size();
        for (int i = 0; i < 30; ++i) {
            int initialIdx = i % palSz;
            JPanel cell = new JPanel();
            cell.setLayout(new BoxLayout(cell, 1));
            cell.setBorder(new EmptyBorder(2, 2, 2, 2));
            JCheckBox cb = new JCheckBox("", true);
            cb.setAlignmentX(0.0f);
            cb.setToolTipText("User slot " + (i + 1));
            this.userChecks[i] = cb;
            Swatch sw = new Swatch(initialIdx, idx -> this.recomputeMapAndPreview());
            sw.setAlignmentX(0.0f);
            this.userSwatches[i] = sw;
            cb.addActionListener(e -> {
                if (this.currentFilter == FilterType.USER_COLORS) {
                    this.recomputeMapAndPreview();
                }
            });
            cell.add(cb);
            cell.add(sw);
            userGrid.add(cell);
        }
        userPanel.add((Component)new JScrollPane(userGrid, 21, 30), "Center");
        this.filterSettingsCards.add((Component)userPanel, FilterType.USER_COLORS.name());
        leftPanel.add(this.filterSettingsCards);
        ActionListener filterChange = e -> {
            if (e.getSource() == this.rbBW) {
                this.currentFilter = FilterType.BW;
            } else if (e.getSource() == this.rbGray) {
                this.currentFilter = FilterType.GRAYSCALE;
            } else if (e.getSource() == this.rbSepia) {
                this.currentFilter = FilterType.SEPIA;
            } else if (e.getSource() == this.rbHybridBlue) {
                this.currentFilter = FilterType.HYBRID_BLUE;
            } else if (e.getSource() == this.rbHybridGreen) {
                this.currentFilter = FilterType.HYBRID_GREEN;
            } else if (e.getSource() == this.rbUserColors) {
                this.currentFilter = FilterType.USER_COLORS;
            }
            CardLayout cl = (CardLayout)this.filterSettingsCards.getLayout();
            cl.show(this.filterSettingsCards, this.currentFilter.name());
            this.recomputeMapAndPreview();
        };
        this.rbBW.addActionListener(filterChange);
        this.rbGray.addActionListener(filterChange);
        this.rbSepia.addActionListener(filterChange);
        this.rbHybridBlue.addActionListener(filterChange);
        this.rbHybridGreen.addActionListener(filterChange);
        this.rbUserColors.addActionListener(filterChange);
        this.bwThresholdSlider.addChangeListener(e -> {
            int v = this.bwThresholdSlider.getValue();
            this.bwValueLabel.setText(String.valueOf(v));
            if (this.currentFilter == FilterType.BW) {
                this.recomputeMapAndPreview();
            }
        });
        this.previewPanel = new PreviewPanel();
        JPanel rightPanel = new JPanel(new BorderLayout(4, 4));
        rightPanel.setBorder(BorderFactory.createTitledBorder("Preview (2:1, 200%)"));
        rightPanel.add((Component)this.previewPanel, "Center");
        JPanel bottom = new JPanel(new FlowLayout(2, 8, 0));
        JButton btnCancel = new JButton("Cancel");
        JButton btnApply = new JButton("Apply");
        btnCancel.addActionListener(e -> this.dispose());
        btnApply.addActionListener(e -> this.applyFilterAndClose());
        bottom.add(btnCancel);
        bottom.add(btnApply);
        this.add((Component)leftPanel, "West");
        this.add((Component)rightPanel, "Center");
        this.add((Component)bottom, "South");
        this.recomputeMapAndPreview();
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setMinimumSize(new Dimension(910, 520));
    }

    private void recomputeMapAndPreview() {
        this.currentMap = this.buildIndexMapForCurrentFilter();
        this.previewPanel.repaint();
    }

    private int[] buildIndexMapForCurrentFilter() {
        int[] map = new int[this.paletteSize];
        switch (this.currentFilter.ordinal()) {
            case 0: {
                this.buildMapBW(map);
                break;
            }
            case 1: {
                this.buildMapLimitedColumns(map, new int[]{1}, true, true);
                break;
            }
            case 2: {
                this.buildMapLimitedColumns(map, new int[]{7}, true, false);
                break;
            }
            case 3: {
                this.buildMapLimitedColumns(map, new int[]{6, 13, 14}, true, false);
                break;
            }
            case 4: {
                this.buildMapLimitedColumns(map, new int[]{5, 10, 12, 15}, true, false);
                break;
            }
            case 5: {
                this.buildMapUserColors(map);
            }
        }
        return map;
    }

    private void buildMapBW(int[] map) {
        int thr = this.bwThresholdSlider.getValue();
        for (int i = 0; i < this.paletteSize; ++i) {
            double b = this.brightness(this.paletteColors[i]);
            map[i] = b < (double)thr ? this.blackIndex : this.whiteIndex;
        }
    }

    private void buildMapLimitedColumns(int[] map, int[] columnsZeroBased, boolean includeBlack, boolean includeWhite) {
        int rows = this.paletteSize / 16;
        ArrayList<Integer> allowed = new ArrayList<Integer>();
        if (includeBlack) {
            allowed.add(this.blackIndex);
        }
        if (includeWhite) {
            allowed.add(this.whiteIndex);
        }
        for (int col : columnsZeroBased) {
            for (int row = 0; row < rows; ++row) {
                int idx = row * 16 + col;
                if (idx < 0 || idx >= this.paletteSize || allowed.contains(idx)) continue;
                allowed.add(idx);
            }
        }
        if (allowed.isEmpty()) {
            for (int i = 0; i < this.paletteSize; ++i) {
                map[i] = i;
            }
            return;
        }
        int[] allowedArr = allowed.stream().mapToInt(Integer::intValue).toArray();
        for (int i = 0; i < this.paletteSize; ++i) {
            map[i] = this.nearestIndex(i, allowedArr);
        }
    }

    private void buildMapUserColors(int[] map) {
        int i;
        ArrayList<Integer> allowed = new ArrayList<Integer>();
        for (i = 0; i < 30; ++i) {
            int idx;
            if (this.userChecks[i] == null || !this.userChecks[i].isSelected() || this.userSwatches[i] == null || allowed.contains(idx = this.userSwatches[i].getIndex())) continue;
            allowed.add(idx);
        }
        if (allowed.isEmpty()) {
            for (i = 0; i < this.paletteSize; ++i) {
                map[i] = i;
            }
            return;
        }
        int[] allowedArr = allowed.stream().mapToInt(Integer::intValue).toArray();
        for (int i2 = 0; i2 < this.paletteSize; ++i2) {
            map[i2] = this.nearestIndex(i2, allowedArr);
        }
    }

    private void applyFilterAndClose() {
        int y;
        if (this.currentMap == null) {
            this.dispose();
            return;
        }
        if (this.beforeApply != null) {
            this.beforeApply.run();
        }
        int[] map = this.currentMap;
        for (y = 0; y < this.pic.getYs(); ++y) {
            int v15 = this.pic.getFF15Line()[y] & 0xFF;
            int v16 = this.pic.getFF16Line()[y] & 0xFF;
            this.pic.getFF15Line()[y] = (byte)(this.applyMapToIndex(v15, map) & 0xFF);
            this.pic.getFF16Line()[y] = (byte)(this.applyMapToIndex(v16, map) & 0xFF);
        }
        for (y = 0; y < 200; ++y) {
            for (int x = 0; x < 160; ++x) {
                int[] aux = this.pic.getAuxColorsAt(x, y);
                int a0 = aux[0] & 0xFF;
                int a1 = aux[1] & 0xFF;
                this.pic.setAuxColorAt(x, y, 0, this.applyMapToIndex(a0, map));
                this.pic.setAuxColorAt(x, y, 1, this.applyMapToIndex(a1, map));
            }
        }
        this.dispose();
    }

    private int applyMapToIndex(int idx, int[] map) {
        if (map == null || idx < 0 || idx >= map.length) {
            return idx;
        }
        return map[idx] & 0xFF;
    }

    private int nearestIndex(int srcIdx, int[] allowed) {
        Color src = this.paletteColors[srcIdx];
        double best = Double.MAX_VALUE;
        int bestIdx = srcIdx;
        for (int candidate : allowed) {
            Color c = this.paletteColors[candidate];
            double d = this.colorDistSq(src, c);
            if (!(d < best)) continue;
            best = d;
            bestIdx = candidate;
        }
        return bestIdx;
    }

    private double colorDistSq(Color a, Color b) {
        double dr = a.getRed() - b.getRed();
        double dg = a.getGreen() - b.getGreen();
        double db = a.getBlue() - b.getBlue();
        return dr * dr + dg * dg + db * db;
    }

    private double brightness(Color c) {
        return 0.299 * (double)c.getRed() + 0.587 * (double)c.getGreen() + 0.114 * (double)c.getBlue();
    }

    private int findDarkestIndex() {
        double best = Double.MAX_VALUE;
        int bestIdx = 0;
        for (int i = 0; i < this.paletteSize; ++i) {
            double b = this.brightness(this.paletteColors[i]);
            if (!(b < best)) continue;
            best = b;
            bestIdx = i;
        }
        return bestIdx;
    }

    private int findBrightestIndex() {
        double best = -1.0;
        int bestIdx = 0;
        for (int i = 0; i < this.paletteSize; ++i) {
            double b = this.brightness(this.paletteColors[i]);
            if (!(b > best)) continue;
            best = b;
            bestIdx = i;
        }
        return bestIdx;
    }

    private static int choosePalette(Window parent, int initialIndex) {
        final JDialog dlg = new JDialog(parent, "Choose Plus/4 color", Dialog.ModalityType.APPLICATION_MODAL);
        JPanel grid = new JPanel(new GridLayout(8, 16, 2, 2));
        grid.setBorder(new EmptyBorder(8, 8, 8, 8));
        final int[] result = new int[]{-1};
        int total = Plus4Palette.size();
        int i = 0;
        while (i < total) {
            JPanel cell = new JPanel();
            cell.setBackground(Plus4Palette.getColor(i));
            cell.setPreferredSize(new Dimension(22, 18));
            cell.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            final int idx = i++;
            cell.setToolTipText(String.format("#%d (0x%02X)", idx, idx));
            cell.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    result[0] = idx;
                    dlg.dispose();
                }
            });
            grid.add(cell);
        }
        JPanel south = new JPanel(new FlowLayout(2, 8, 8));
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(e -> {
            result[0] = -1;
            dlg.dispose();
        });
        south.add(cancel);
        dlg.setLayout(new BorderLayout());
        dlg.add((Component)grid, "Center");
        dlg.add((Component)south, "South");
        dlg.pack();
        dlg.setLocationRelativeTo(parent);
        dlg.setVisible(true);
        return result[0];
    }

    private static enum FilterType {
        BW,
        GRAYSCALE,
        SEPIA,
        HYBRID_BLUE,
        HYBRID_GREEN,
        USER_COLORS;

    }

    private static class Swatch
    extends JPanel {
        private int index;
        private final IntConsumer onChange;

        Swatch(int idx, IntConsumer onChange) {
            this.index = idx & 0xFF;
            this.onChange = onChange;
            this.setPreferredSize(new Dimension(24, 16));
            this.setMaximumSize(new Dimension(24, 16));
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            this.setBackground(Plus4Palette.getColor(this.index));
            this.setToolTipText(String.format("Index: %d ($%02X)", this.index, this.index));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int sel = ColorFilterDialog.choosePalette(SwingUtilities.getWindowAncestor(this), index);
                    if (sel >= 0) {
                        this.setIndex(sel);
                    }
                }
            });
        }

        void setIndex(int idx) {
            this.index = idx & 0xFF;
            this.setBackground(Plus4Palette.getColor(this.index));
            this.setToolTipText(String.format("Index: %d ($%02X)", this.index, this.index));
            this.repaint();
            if (this.onChange != null) {
                this.onChange.accept(this.index);
            }
        }

        int getIndex() {
            return this.index;
        }
    }

    private class PreviewPanel
    extends JPanel {
        PreviewPanel() {
            this.setPreferredSize(new Dimension(640, 400));
            this.setMinimumSize(new Dimension(640, 400));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int[] map = ColorFilterDialog.this.currentMap;
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            double scaleX = 4.0;
            double scaleY = 2.0;
            for (int y = 0; y < 200; ++y) {
                int actY = Math.min(Math.max(y, 0), ColorFilterDialog.this.pic.getYs() - 1);
                int idx0 = ColorFilterDialog.this.pic.getFF15Line()[actY] & 0xFF;
                int idx1 = ColorFilterDialog.this.pic.getFF16Line()[actY] & 0xFF;
                for (int x = 0; x < 160; ++x) {
                    int v = ColorFilterDialog.this.pic.getPixel2bpp(x, y) & 3;
                    int idx = switch (v) {
                        case 0 -> idx0;
                        case 1 -> ColorFilterDialog.this.pic.getAuxColorsAt(x, y)[1] & 0xFF;
                        case 2 -> ColorFilterDialog.this.pic.getAuxColorsAt(x, y)[0] & 0xFF;
                        default -> idx1;
                    };
                    idx = ColorFilterDialog.this.applyMapToIndex(idx, map);
                    Color c = Plus4Palette.getColor(idx);
                    int sx = (int)Math.floor((double)x * scaleX);
                    int sy = (int)Math.floor((double)y * scaleY);
                    int sw = Math.max(1, (int)Math.ceil((double)(x + 1) * scaleX) - sx);
                    int sh = Math.max(1, (int)Math.ceil((double)(y + 1) * scaleY) - sy);
                    g.setColor(c);
                    g.fillRect(sx, sy, sw, sh);
                }
            }
        }
    }
}

