/*
 * Decompiled with CFR 0.152.
 */
package com.bitmester.model;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class Plus4Palette {
    private static final String[] RESOURCE_NAMES = new String[]{"/plus4colortable.act", "/plus4palette.act"};
    private static final int COLORS_COUNT = 128;
    private static final int BYTES_WANTED = 384;
    private static final List<Color> COLORS = new ArrayList<Color>(128);

    private Plus4Palette() {
    }

    private static byte[] sliceFirst(byte[] src, int maxLen) {
        int n = Math.min(maxLen, src.length);
        byte[] out = new byte[n];
        System.arraycopy(src, 0, out, 0, n);
        return out;
    }

    public static int size() {
        return COLORS.size();
    }

    public static Color getColor(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index >= COLORS.size()) {
            index = COLORS.size() - 1;
        }
        return COLORS.get(index);
    }

    static {
        byte[] data = null;
        for (String res : RESOURCE_NAMES) {
            try (InputStream in2 = Plus4Palette.class.getResourceAsStream(res);){
                byte[] all;
                if (in2 == null || (all = in2.readAllBytes()).length < 3) continue;
                data = Plus4Palette.sliceFirst(all, 384);
                System.err.println("[INFO] Loaded ACT from resource: " + res + " (" + data.length + " bytes)");
                break;
            }
            catch (Exception in2) {
                // empty catch block
            }
        }
        if (data == null) {
            String[] tries;
            for (String p : tries = new String[]{"plus4colortable.act", "src/main/resources/plus4colortable.act", "out/plus4colortable.act", "out/resources/plus4colortable.act", "plus4palette.act", "src/main/resources/plus4palette.act", "io/plus4palette.act", "out/resources/plus4palette.act"}) {
                File f = new File(p);
                if (!f.isFile()) continue;
                try (FileInputStream in = new FileInputStream(f);){
                    byte[] all = ((InputStream)in).readAllBytes();
                    if (all.length < 3) continue;
                    data = Plus4Palette.sliceFirst(all, 384);
                    System.err.println("[INFO] Loaded ACT from file: " + f.getPath() + " (" + data.length + " bytes)");
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (data == null) {
            System.err.println("[WARN] ACT palette not found \u2013 using 128-step grayscale fallback");
            for (int i = 0; i < 128; ++i) {
                int v = (int)Math.round(255.0 * (double)i / 127.0);
                COLORS.add(new Color(v, v, v));
            }
        } else {
            int triplets = data.length / 3;
            int count = Math.min(128, triplets);
            for (int i = 0; i < count; ++i) {
                int r = data[i * 3] & 0xFF;
                int g = data[i * 3 + 1] & 0xFF;
                int b = data[i * 3 + 2] & 0xFF;
                COLORS.add(new Color(r, g, b));
            }
            while (COLORS.size() < 128) {
                COLORS.add(new Color(0, 0, 0));
            }
        }
    }
}

