/*
 * Decompiled with CFR 0.152.
 */
package com.bitmester.io;

import com.bitmester.model.PictureInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.IntUnaryOperator;

public final class PrgImporter {
    private PrgImporter() {
    }

    public static void importPRG(PictureInfo pic, File file) throws IOException {
        byte[] prg;
        try (FileInputStream fis = new FileInputStream(file);){
            prg = fis.readAllBytes();
        }
        if (prg.length < 2) {
            throw new IOException("PRG t\u00fal r\u00f6vid");
        }
        int load = prg[0] & 0xFF | (prg[1] & 0xFF) << 8;
        byte[] mem = Arrays.copyOfRange(prg, 2, prg.length);
        IntUnaryOperator get = addr -> {
            int off = addr - load;
            if (off < 0 || off >= mem.length) {
                throw new RuntimeException(String.format("C\u00edmtartom\u00e1nyon k\u00edv\u00fcl: $%04X", addr));
            }
            return mem[off] & 0xFF;
        };
        for (int y = 0; y < 200; ++y) {
            pic.getFF15Line()[y] = (byte)get.applyAsInt(6656 + y);
            pic.getFF16Line()[y] = (byte)get.applyAsInt(6912 + y);
        }
        byte[] bmp = new byte[8000];
        for (int row = 0; row < 25; ++row) {
            for (int xChar = 0; xChar < 40; ++xChar) {
                for (int yInChar = 0; yInChar < 8; ++yInChar) {
                    int addr2 = 8384 + row * 320 + xChar * 8 + yInChar;
                    bmp[row * 320 + xChar * 8 + yInChar] = (byte)get.applyAsInt(addr2);
                }
            }
        }
        PrgImporter.fillPixelsFromPlus4Bitmap(pic, bmp);
        int[] LUMA_BASE = new int[]{16408, 18456, 20504, 22552};
        int[] CHROMA_BASE = new int[]{17432, 19480, 21528, 23576};
        for (int band = 0; band < 4; ++band) {
            int baseL = LUMA_BASE[band];
            int baseC = CHROMA_BASE[band];
            for (int rowPair = 0; rowPair < 25; ++rowPair) {
                int y0 = rowPair * 8 + band * 2;
                for (int xChar = 0; xChar < 40; ++xChar) {
                    int addrL = baseL + rowPair * 40 + xChar;
                    int addrC = baseC + rowPair * 40 + xChar;
                    int l = get.applyAsInt(addrL);
                    int c = get.applyAsInt(addrC);
                    int aux1L = l >> 4 & 0xF;
                    int aux2L = l & 0xF;
                    int aux2C = c >> 4 & 0xF;
                    int aux1C = c & 0xF;
                    int idxAux1 = (aux1L &= 7) * 16 + aux1C;
                    int idxAux2 = (aux2L &= 7) * 16 + aux2C;
                    int px = xChar * 4;
                    int py = y0;
                    pic.setAuxColorAt(px, py, 0, idxAux1);
                    pic.setAuxColorAt(px, py, 1, idxAux2);
                }
            }
        }
    }

    private static void fillPixelsFromPlus4Bitmap(PictureInfo pic, byte[] packed) {
        int i = 0;
        for (int row = 0; row < 25; ++row) {
            for (int xChar = 0; xChar < 40; ++xChar) {
                int x = xChar * 4;
                for (int yInChar = 0; yInChar < 8; ++yInChar) {
                    int b = packed[i++] & 0xFF;
                    int y = row * 8 + yInChar;
                    pic.setPixel2bpp(x, y, b >> 6 & 3);
                    pic.setPixel2bpp(x + 1, y, b >> 4 & 3);
                    pic.setPixel2bpp(x + 2, y, b >> 2 & 3);
                    pic.setPixel2bpp(x + 3, y, b & 3);
                }
            }
        }
    }
}

