/*
 * Decompiled with CFR 0.152.
 */
package com.bitmester;

import com.bitmester.io.PrgExporter;
import com.bitmester.io.PrgImporter;
import com.bitmester.model.PictureInfo;
import com.bitmester.model.Plus4Palette;
import com.bitmester.ui.ColorFilterDialog;
import com.bitmester.ui.EditorCanvas;
import com.bitmester.ui.PaintChannelPanel;
import com.bitmester.ui.PalettePanel;
import com.bitmester.ui.RemapColorBandsDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.function.BiConsumer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class DFLIEditor
extends JFrame {
    private final PictureInfo pic;
    private final EditorCanvas canvas;
    private final PalettePanel palette;
    private final PaintChannelPanel paintPanel;
    private final JSlider lineSlider;
    private final JSlider zoomSlider;
    private final JLabel status;
    private JButton btnUndo;
    private JLabel lblCursX;
    private JLabel lblCursY;
    private JLabel lblDFLIRow;
    private JLabel lblDFLICol;
    private JLabel lblActualHex;
    private JLabel lblColorIndicator;
    private JPanel pnlActualColor;

    public DFLIEditor() {
        super("MeDFLIstvan Editor v1.00 - Bytehexer");
        JSlider z;
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.pic = new PictureInfo(320, 200);
        this.status = new JLabel();
        this.canvas = new EditorCanvas(this.pic);
        this.canvas.setHeatmapListener(this::refreshStatusAndRepaint);
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DFLIEditor.this.updatePointerFromMouse(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                DFLIEditor.this.updatePointerFromMouse(e);
            }
        });
        JScrollPane scroller = new JScrollPane(this.canvas);
        this.add((Component)scroller, "Center");
        this.palette = new PalettePanel(this.pic, this::refreshStatusAndRepaint);
        JPanel pointerPanel = this.buildPointerPanel();
        this.btnUndo = this.bigButton("Undo \u00d7 0");
        this.btnUndo.setEnabled(false);
        this.btnUndo.addActionListener(e -> {
            if (this.canvas.performUndo()) {
                int left = this.canvas.getUndoCount();
                this.btnUndo.setText("Undo \u00d7 " + left);
                this.btnUndo.setEnabled(left > 0);
                this.refreshStatusAndRepaint();
            }
        });
        this.canvas.setUndoListener(count -> {
            this.btnUndo.setText("Undo \u00d7 " + count);
            this.btnUndo.setEnabled(count > 0);
        });
        JButton btnClearFill = this.bigButton("Clear GFX or ReFill Colors");
        btnClearFill.addActionListener(e -> this.showClearFillDialog());
        JButton btnRemap = this.bigButton("Remap Color Bands");
        btnRemap.addActionListener(e -> {
            new RemapColorBandsDialog((Window)this, this.pic, () -> {
                this.canvas.pushUndoSnapshot();
                int left = this.canvas.getUndoCount();
                this.btnUndo.setText("Undo \u00d7 " + left);
                this.btnUndo.setEnabled(left > 0);
            }).setVisible(true);
            this.refreshStatusAndRepaint();
        });
        JPanel brushPanel = new JPanel(new BorderLayout(4, 0));
        JButton brushButton = this.bigButton("Brush size: normal");
        brushButton.setFocusPainted(false);
        brushButton.addActionListener(e -> {
            JDialog dlg = new JDialog(this, "Brush size", true);
            JPanel grid = new JPanel(new GridLayout(0, 2, 8, 8));
            grid.setBorder(new EmptyBorder(8, 8, 8, 8));
            BiConsumer<String, Integer> addSizeButton = (label, sizePx) -> {
                JButton b = new JButton((String)label);
                b.setFocusPainted(false);
                b.addActionListener(ev -> {
                    this.canvas.setBrushSize((int)sizePx);
                    brushButton.setText((String)label);
                    dlg.dispose();
                });
                grid.add(b);
            };
            addSizeButton.accept("Brush size: normal", 1);
            addSizeButton.accept("Brush size: 2\u00d72", 2);
            addSizeButton.accept("Brush size: 4\u00d74", 4);
            addSizeButton.accept("Brush size: 6\u00d76", 6);
            addSizeButton.accept("Brush size: 8\u00d78", 8);
            addSizeButton.accept("Brush size: 10\u00d710", 10);
            addSizeButton.accept("Brush size: 12\u00d712", 12);
            addSizeButton.accept("Brush size: 16\u00d716", 16);
            addSizeButton.accept("Brush size: 32\u00d732", 32);
            addSizeButton.accept("Brush size: 64\u00d764", 64);
            dlg.getContentPane().add(grid);
            dlg.pack();
            dlg.setLocationRelativeTo(brushButton);
            dlg.setVisible(true);
        });
        brushPanel.add((Component)brushButton, "Center");
        JButton btnColorFilter = this.bigButton("Color Filter");
        btnColorFilter.addActionListener(e -> this.showColorFilterDialog());
        JButton btnHelpAbout = this.bigButton("Help / About");
        btnHelpAbout.addActionListener(e -> this.showHelpAboutDialog());
        JPanel toolsGrid = new JPanel(new GridLayout(3, 2, 8, 8));
        toolsGrid.add(this.btnUndo);
        toolsGrid.add(btnClearFill);
        toolsGrid.add(btnRemap);
        toolsGrid.add(brushPanel);
        toolsGrid.add(btnColorFilter);
        toolsGrid.add(btnHelpAbout);
        JPanel toolsSection = new JPanel();
        toolsSection.setLayout(new BoxLayout(toolsSection, 1));
        toolsSection.add(this.makeSectionHeader("Tools"));
        toolsSection.add(Box.createVerticalStrut(4));
        toolsSection.add(toolsGrid);
        JPanel ioButtons = new JPanel(new GridLayout(1, 2, 8, 8));
        JButton btnImport = this.bigButton("Import PRG\u2026");
        JButton btnExport = this.bigButton("Export PRG+ASM+PNG");
        btnImport.addActionListener(e -> this.doImport(this.btnUndo));
        btnExport.addActionListener(e -> this.doExport());
        ioButtons.add(btnImport);
        ioButtons.add(btnExport);
        JPanel ioSection = new JPanel();
        ioSection.setLayout(new BoxLayout(ioSection, 1));
        ioSection.add(this.makeSectionHeader("I/O"));
        ioSection.add(Box.createVerticalStrut(4));
        ioSection.add(ioButtons);
        this.paintPanel = new PaintChannelPanel(this.pic, idx -> {
            this.pic.setCurrentPaint(idx);
            this.refreshStatusAndRepaint();
        });
        JPanel paintWrapper = new JPanel();
        paintWrapper.setLayout(new BoxLayout(paintWrapper, 1));
        paintWrapper.add(this.makeSectionHeader("PaintChannel"));
        paintWrapper.add(Box.createVerticalStrut(4));
        paintWrapper.add(this.paintPanel);
        JPanel eastTop = new JPanel();
        eastTop.setLayout(new BoxLayout(eastTop, 1));
        eastTop.add(this.palette);
        eastTop.add(Box.createVerticalStrut(8));
        eastTop.add(pointerPanel);
        eastTop.add(Box.createVerticalStrut(8));
        eastTop.add(toolsSection);
        eastTop.add(Box.createVerticalStrut(8));
        eastTop.add(ioSection);
        eastTop.add(Box.createVerticalStrut(8));
        eastTop.add(paintWrapper);
        JPanel eastColumn = new JPanel(new BorderLayout(0, 8));
        eastColumn.add((Component)eastTop, "Center");
        this.add((Component)eastColumn, "East");
        this.lineSlider = new JSlider(0, this.pic.getYs() - 1, 0);
        this.lineSlider.addChangeListener(e -> {
            if (!this.lineSlider.getValueIsAdjusting()) {
                this.pic.setCurY(this.lineSlider.getValue());
                this.refreshStatusAndRepaint();
            }
        });
        this.zoomSlider = z = new JSlider(100, 800, 100);
        this.zoomSlider.setPaintTicks(true);
        this.zoomSlider.setMajorTickSpacing(100);
        this.zoomSlider.setMinorTickSpacing(25);
        this.zoomSlider.addChangeListener(e -> {
            int val = this.zoomSlider.getValue();
            this.canvas.setZoomPercent(val);
            this.refreshStatusAndRepaint();
        });
        JPanel south = new JPanel(new BorderLayout(8, 0));
        JPanel southTop = new JPanel(new GridLayout(1, 2, 12, 0));
        southTop.add(new Labeled("Rasterline Y", this.lineSlider));
        southTop.add(new Labeled("Zoom %", this.zoomSlider));
        south.add((Component)southTop, "Center");
        south.add((Component)this.status, "South");
        this.add((Component)south, "South");
        this.setJMenuBar(this.buildMenu());
        this.setSize(1220, 800);
        JRootPane root = this.getRootPane();
        InputMap rim = root.getInputMap(2);
        ActionMap ram = root.getActionMap();
        rim.put(KeyStroke.getKeyStroke(68, 0), "toggleDfliGrid");
        ram.put("toggleDfliGrid", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DFLIEditor.this.canvas.toggleDfliGrid();
            }
        });
        this.clearGfxAll();
        this.setLocationRelativeTo(null);
        this.refreshStatusAndRepaint();
    }

    private JPanel buildPointerPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(new EmptyBorder(4, 0, 4, 0));
        p.add(this.makeSectionHeader("Pointer"));
        p.add(Box.createVerticalStrut(4));
        JPanel row1 = new JPanel(new GridLayout(1, 4, 8, 3));
        this.lblCursX = new JLabel("Actual X: ---");
        this.lblCursX.setFont(this.lblCursX.getFont().deriveFont(1, 14.0f));
        this.lblCursY = new JLabel("Actual Y: ---");
        this.lblCursY.setFont(this.lblCursY.getFont().deriveFont(1, 14.0f));
        this.lblDFLIRow = new JLabel("DFLI Row: --");
        this.lblDFLIRow.setFont(this.lblCursY.getFont().deriveFont(1, 14.0f));
        this.lblDFLICol = new JLabel("DFLI Column: --");
        this.lblDFLICol.setFont(this.lblCursY.getFont().deriveFont(1, 14.0f));
        row1.add(this.lblCursX);
        row1.add(this.lblCursY);
        row1.add(this.lblDFLIRow);
        row1.add(this.lblDFLICol);
        p.add(row1);
        JPanel row2 = new JPanel(new GridLayout(1, 4, 8, 3));
        Font f = row2.getFont().deriveFont(1, 14.0f);
        JPanel cell1 = new JPanel(new FlowLayout(0, 0, 0));
        JLabel lblActualTitle = new JLabel("Actual color: ");
        lblActualTitle.setFont(f);
        this.pnlActualColor = new JPanel();
        this.pnlActualColor.setPreferredSize(new Dimension(24, 16));
        this.pnlActualColor.setMinimumSize(new Dimension(24, 16));
        this.pnlActualColor.setMaximumSize(new Dimension(24, 16));
        this.pnlActualColor.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        cell1.add(lblActualTitle);
        cell1.add(this.pnlActualColor);
        JPanel cell2 = new JPanel(new FlowLayout(0, 0, 0));
        this.lblActualHex = new JLabel("Hex: $00");
        this.lblActualHex.setFont(f);
        cell2.add(this.lblActualHex);
        JPanel cell3 = new JPanel(new FlowLayout(0, 0, 0));
        JLabel lblIndicatorTitle = new JLabel("Actual PaintChannel:");
        lblIndicatorTitle.setFont(f);
        cell3.add(lblIndicatorTitle);
        JPanel cell4 = new JPanel(new FlowLayout(0, 0, 0));
        this.lblColorIndicator = new JLabel("");
        this.lblColorIndicator.setFont(f);
        cell4.add(this.lblColorIndicator);
        row2.add(cell1);
        row2.add(cell2);
        row2.add(cell3);
        row2.add(cell4);
        p.add(row2);
        return p;
    }

    private void updatePointerFromMouse(MouseEvent e) {
        int idx;
        int w = this.canvas.getWidth();
        int h = this.canvas.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        double base = (double)this.pic.getZoomPercent() / 100.0;
        double scaleX = 2.0 * base;
        double scaleY = 1.0 * base;
        int imgW = (int)Math.floor(160.0 * scaleX);
        int imgH = (int)Math.floor(200.0 * scaleY);
        int offX = (w - imgW) / 2;
        int offY = (h - imgH) / 2;
        int px = e.getX();
        int py = e.getY();
        if (px < offX || py < offY || px >= offX + imgW || py >= offY + imgH) {
            this.setPointerDisplayInvalid();
            return;
        }
        int x = (int)Math.floor((double)(px - offX) / scaleX);
        int y = (int)Math.floor((double)(py - offY) / scaleY);
        if (x < 0 || x >= 160 || y < 0 || y >= 200) {
            this.setPointerDisplayInvalid();
            return;
        }
        int dfliCol = x / 4;
        int dfliRow = y / 2 * 2;
        this.lblCursX.setText(String.format("Actual X: %03d", x));
        this.lblCursY.setText(String.format("Actual Y: %03d", y));
        this.lblDFLIRow.setText(String.format("DFLI Row: %02d", dfliRow));
        this.lblDFLICol.setText(String.format("DFLI Column: %02d", dfliCol));
        int v = this.pic.getPixel2bpp(x, y) & 3;
        String indicator = switch (v) {
            case 0 -> {
                idx = this.pic.getFF15Line()[y] & 0xFF;
                yield "0 \u2013 FF15 (BG)";
            }
            case 1 -> {
                idx = this.pic.getAuxColorsAt(x, y)[1] & 0xFF;
                yield "1 \u2013 FF14 AUX1";
            }
            case 2 -> {
                idx = this.pic.getAuxColorsAt(x, y)[0] & 0xFF;
                yield "2 \u2013 FF14 AUX0";
            }
            default -> {
                idx = this.pic.getFF16Line()[y] & 0xFF;
                yield "3 \u2013 FF16 (MC1)";
            }
        };
        this.pnlActualColor.setBackground(Plus4Palette.getColor(idx));
        this.lblActualHex.setText(String.format("Hex: $%02X", idx & 0xFF));
        this.lblColorIndicator.setText(indicator);
        this.pnlActualColor.repaint();
    }

    private void setPointerDisplayInvalid() {
        if (this.lblCursX != null) {
            this.lblCursX.setText("Actual X: ---");
        }
        if (this.lblCursY != null) {
            this.lblCursY.setText("Actual Y: ---");
        }
        if (this.lblDFLIRow != null) {
            this.lblDFLIRow.setText("DFLI Row: --");
        }
        if (this.lblDFLICol != null) {
            this.lblDFLICol.setText("DFLI Column: --");
        }
        if (this.lblActualHex != null) {
            this.lblActualHex.setText("Hex: $00");
        }
        if (this.lblColorIndicator != null) {
            this.lblColorIndicator.setText("--");
        }
        if (this.pnlActualColor != null) {
            this.pnlActualColor.setBackground(Color.BLACK);
            this.pnlActualColor.repaint();
        }
    }

    private void showColorFilterDialog() {
        new ColorFilterDialog((Window)this, this.pic, () -> {
            this.canvas.pushUndoSnapshot();
            this.updateUndoButtonFromCanvas();
        }).setVisible(true);
        this.refreshStatusAndRepaint();
    }

    private void showHelpAboutDialog() {
        JDialog dlg = new JDialog(this, "Help / About", true);
        dlg.setLayout(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        JTextArea helpText = new JTextArea();
        helpText.setEditable(false);
        helpText.setFont(new Font("SansSerif", 0, 14));
        helpText.setBorder(new EmptyBorder(10, 10, 10, 10));
        helpText.setText("MeDFLIstvan Editor \u2013 Help\nMulti-editor-of-DFLI-Istvanv's mode\n===========================\n\nOverview\n---------------------\nThis editor is designed for Plus/4 DFLI graphics using the istvanv layout.\nYou work on a 160\u00d7200 logical bitmap with 4 paint channels per pixel:\n  0 \u2192 FF15 background (per raster line)\n  1 \u2192 AUX1 (FF14 band colors, slot1)\n  2 \u2192 AUX0 (FF14 band colors, slot0)\n  3 \u2192 FF16 (per raster line, MC1/foreground)\n\nThe right side shows:\n  - Pointer panel (cursor X/Y, DFLI row/column, color under cursor).\n  - Tools section (Undo, Clear/Fill GFX, Remap Color Bands, Brush size,\n    Color Filter, Help/About).\n  - I/O section (Import PRG\u2026, Export PRG\u2026).\n  - PaintChannel panel (select active paint channel 0..3).\n\nClear / Fill GFX\n---------------------\nTools \u2192 \"Clear GFX or ReFill Colors\" opens a dialog which can:\n  - Clear the entire bitmap and all color maps (FF15, FF16, AUX0, AUX1).\n  - Optionally refill each map ($FF15, AUX1, AUX0, $FF16) with user-selected\n    colors from the Plus/4 palette.\nImportant:\n  - Both \"Yes\" (clear) and \"Apply\" (refill) automatically push an Undo\n    snapshot, so you can revert the operation via Undo \u00d73.\n\nRemap Color Bands\n---------------------\nTools \u2192 \"Remap Color Bands\" opens a detailed FF14 remap dialog.\nYou can:\n  - Inspect AUX0/AUX1 band colors per DFLI column.\n  - Change band colors using swatches and the Plus/4 palette.\n  - Apply the remap with a single operation.\nWhen Apply is pressed, the editor:\n  - First pushes an Undo snapshot.\n  - Then rewrites AUX0/AUX1 according to your remap choices.\n\nColor Filter\n---------------------\nTools \u2192 \"Color Filter\" opens a separate ColorFilter dialog.\nAvailable filters:\n  - Black & White with Threshold\n       Uses a brightness threshold (0..255). Below = Black, above = White.\n  - Grayscale\n       Maps colors into a greyscale subset (palette column 2 + black/white).\n  - Sepia\n       Uses palette column 8 + black for a warm brownish look.\n  - Hybrid Blue\n       Restricts mapping to a blue-ish subset (limited columns) plus black.\n  - Hybrid Green\n       Restricts mapping to green-ish subset columns plus black.\n  - User Colors\n       You define up to 30 custom palette indices (5\u00d76 grid). Each slot has\n       a checkbox and a swatch. The active, checked slots form the target\n       palette; all original colors are mapped to the nearest of these.\n\nColor Filter Preview & Apply\n---------------------\n  - The right-hand preview is a 2:1 aspect, 200% zoom view (640\u00d7400) that\n    shows how the current filter would affect the picture.\n  - Changing filter type, BW threshold, or User Colors immediately updates\n    the preview.\n  - Pressing Apply:\n       \u2022 Pushes an Undo snapshot via the provided callback.\n       \u2022 Remaps FF15, FF16 and AUX0/AUX1 color indices using the chosen\n         filter mapping table.\n\nRecolor 4\u00d72 Block\n---------------------\nCanvas \u2192 Ctrl + Left Click opens the \"Recolor 4\u00d72 block\" dialog at the\ncolor block under the cursor.\n  - The dialog shows the X/Y block coordinates.\n  - You can optionally change:\n       \u2022 AUX0 color (for that 4\u00d72 block)\n       \u2022 AUX1 color (for that 4\u00d72 block)\n       \u2022 FF15 row1 and row2 (background for the two raster lines)\n       \u2022 FF16 row1 and row2 (MC1 for the two raster lines)\n  - Each row has: checkbox, label, color swatch, hex index ($00..$FF).\n  - Apply pushes an Undo snapshot first, then rewrites the corresponding\n    colors for the targeted 4\u00d72 block.\n\nBrush Size & Painting\n---------------------\nTools \u2192 \"Brush size\" opens a small popup with discrete sizes:\n  - normal (1\u00d71), 2\u00d72, 4\u00d74, 6\u00d76, 8\u00d78, 10\u00d710, 12\u00d712, 16\u00d716, 32\u00d732, 64\u00d764.\nThe brush works with both left-click painting and right-click channel cycling.\n  - A white outline rectangle on the canvas shows the current brush footprint.\n\nImport / Export PRG\n---------------------\nI/O \u2192 \"Import PRG\u2026\"\n  - Loads a DFLI PRG that follows the istvanv layout only.\n  - Recommended to create it with the \"p4fliconv\" tool (istvanv):\n       \u2022 MultiColor FLI mode\n       \u2022 Vertical resolution: 200\n       \u2022 x shift field 0: 0\n  - Before import, the editor automatically clears the bitmap and color maps\n    to ensure a clean state.\n\nI/O \u2192 \"Export PRG\u2026\"\n  - Uses the built-in dfli.prg template (istvanv layout) to generate\n    a runnable Plus/4 PRG + PNG Bitmap.\n  - Also generates a companion ASM file with:\n       \u2022 FF15 and FF16 tables (200 bytes each)\n       \u2022 Bitmap data ($20C0-$3FFF) in the exact packing order\n       \u2022 FF14 LUMA/CHROMA tables for all 4 bands\n  - BYTE tables are formatted for CBM PRG Studio, 8 bytes per line.\n\nStatus Bar & Sliders\n---------------------\nBottom of the window:\n  - Current Rasterline Y slider selects the current raster line (0..199). A white rectangle\n    highlights it on the canvas.\n  - Zoom slider controls canvas zoom from 100% to 800%.\n  - Status line shows: CurY, FF15, FF16, Paint channel, aux paints,\n    Zoom %, and Heatmap state.\n");
        JScrollPane helpScroll = new JScrollPane(helpText);
        SwingUtilities.invokeLater(() -> helpText.setCaretPosition(0));
        tabs.addTab("Help", helpScroll);
        JTextArea shortcutsText = new JTextArea();
        shortcutsText.setEditable(false);
        shortcutsText.setFont(new Font("SansSerif", 0, 14));
        shortcutsText.setBorder(new EmptyBorder(10, 10, 10, 10));
        shortcutsText.setText("MeDFLIstvan Editor \u2013 Keyboard & Mouse Shortcuts\n=======================================\n\nCanvas \u2013 Mouse\n---------------------\nLeft Click              : Paint using current brush size and paint channel\nRight Click             : Cycle pixel channel in brush area (0\u21921\u21922\u21923\u21920)\nAlt + Left Click        : Eyedropper \u2013 pick channel + color under cursor\n                               (no paint, no Undo push)\nCtrl + Left Click       : Open \"Recolor 4\u00d72 block\" dialog at cursor block\nMouse Move              : Shows brush outline and updates Pointer panel\nMouse Drag (Left)       : Continuous painting with current brush\nMouse Drag (Right)      : Continuous channel cycling with current brush\n\nCanvas \u2013 Grids & Heatmap\n---------------------\nCapsLock          : Toggle 40\u00d725 char grid overlay (white)\nD                       : Toggle 40\u00d7100 DFLI grid overlay (yellow)\nH                       : Toggle Heatmap overlay for current paint channel\n                          (only pixels belonging to that channel are tinted)\n\nPaint Channel Override\n---------------------\nHold 0                  : Force paint channel 0 (FF15 background)\nHold 1                  : Force paint channel 1 (AUX1 / slot1)\nHold 2                  : Force paint channel 2 (AUX0 / slot0)\nHold 3                  : Force paint channel 3 (FF16 / MC1)\nNote:\n  - Override affects BOTH the canvas painting and the Palette panel clicks.\n  - Without override, palette clicks target the currently selected\n    PaintChannel (0..3) on the right-hand panel.\n\nPalette Panel \u2013 Mouse\n---------------------\nLeft Click           : Set color for the active paint channel:\n                          \u2022 0 \u2192 FF15 at Current RasterLine Y\n                          \u2022 1 \u2192 AUX1 paint index (colmapPaintIndex3)\n                          \u2022 2 \u2192 AUX0 paint index (colmapPaintIndex2)\n                          \u2022 3 \u2192 FF16 at Current RasterLine Y\nRight Click         : Always sets FF16 at CurY (legacy workflow)\nPalette hover     : Tooltip shows palette index as hex ($00..$FF)\n\nPointer Panel\n---------------------\nShows in real time:\n  - Actual X / Y (0..159 / 0..199)\n  - DFLI Row (0,2,4,...,198) and DFLI Column (0..39)\n  - Actual color swatch + Hex value ($00..$FF)\n  - Actual PaintChannel indicator:\n       0 \u2013 FF15 (BG)\n       1 \u2013 FF14 AUX1\n       2 \u2013 FF14 AUX0\n       3 \u2013 FF16 (MC1)\n\nUndo System\n---------------------\nUndo Button (Tools)     : Revert last operation (max depth = 3)\nAutomatic snapshots     : Pushed when you:\n  - Start a paint stroke on canvas\n  - Press Yes/Apply in Clear/Fill GFX\n  - Press Apply in Remap Color Bands\n  - Press Apply in Color Filter\n  - Press Apply in Recolor 4\u00d72 block\n\nSliders & Status\n---------------------\nCurrent Rasterline Y slider (bottom)    : Move current raster line (also updates FF15/FF16\n                                          when painting or using palette for channel 0/3).\nZoom slider (bottom)    : 100\u2013800% canvas zoom.\n");
        JScrollPane shortcutsScroll = new JScrollPane(shortcutsText);
        SwingUtilities.invokeLater(() -> shortcutsText.setCaretPosition(0));
        tabs.addTab("Shortcuts", shortcutsScroll);
        JTextArea aboutText = new JTextArea();
        aboutText.setEditable(false);
        aboutText.setFont(new Font("SansSerif", 0, 14));
        aboutText.setBorder(new EmptyBorder(10, 10, 10, 10));
        aboutText.setText("MeDFLIstvan Editor Version: v1.00\n===========================\n\nRelease: 2025\nAuthor: Bytehexer\nTeam: Monarchy\n\nKey Features:\n- DFLI painting / editing system on 160\u00d7200 bitmap\n- Multi-channel Plus/4 color handling:\n    \u2022 FF15 background per raster line\n    \u2022 FF14 AUX0/AUX1 (4 bands, luma/chroma)\n    \u2022 FF16 per raster line MC1\n- Pointer inspector panel (X/Y, DFLI row/col, color, channel)\n- Heatmap visualization per paint channel\n- 3-level Undo system (paint + major operations)\n- Brush sizes from 1\u00d71 up to 64\u00d764\n- Clear/Fill GFX with selective refill\n- Remap Color Bands dialog for FF14 bands\n- Color Filter dialog with multiple palette-limited modes + User Colors\n- Recolor 4\u00d72 block dialog for local color adjustments\n- PRG + ASM + PNG export using dfli template\n- Compatible with istvanv/p4fliconv-generated DFLI PRGs\n\nN\u00fcrnberg Falcons, k\u00e4mpfen und siegen!\n\nWith lots of love to all Plus/4 graphic artists :)\n");
        JScrollPane aboutScroll = new JScrollPane(aboutText);
        tabs.addTab("About", aboutScroll);
        dlg.add((Component)tabs, "Center");
        JButton close = new JButton("Close");
        close.addActionListener(e -> dlg.dispose());
        JPanel bottom = new JPanel(new FlowLayout(2));
        bottom.add(close);
        dlg.add((Component)bottom, "South");
        dlg.setSize(660, 640);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
    }

    private void showClearFillDialog() {
        int ff15Idx = this.pic.getFF15Line()[this.pic.getCurY()] & 0xFF;
        int aux1Idx = this.pic.getColmapPaintIndex3() & 0xFF;
        int aux0Idx = this.pic.getColmapPaintIndex2() & 0xFF;
        int ff16Idx = this.pic.getFF16Line()[this.pic.getCurY()] & 0xFF;
        int[] chosen = new int[]{ff15Idx, aux1Idx, aux0Idx, ff16Idx};
        JPanel root = new JPanel();
        root.setLayout(new BoxLayout(root, 1));
        root.setBorder(new EmptyBorder(8, 8, 8, 8));
        JPanel pClear = new JPanel(new BorderLayout(8, 8));
        JLabel lblClear = new JLabel("This will clear the bitmap GFX and all color Maps! Are you sure?");
        pClear.add((Component)lblClear, "Center");
        JPanel pClearBtns = new JPanel(new FlowLayout(2, 8, 0));
        JButton yes = new JButton("Yes");
        JButton no = new JButton("No");
        pClearBtns.add(no);
        pClearBtns.add(yes);
        pClear.add((Component)pClearBtns, "South");
        root.add(pClear);
        root.add(Box.createVerticalStrut(6));
        root.add(new JSeparator(0));
        root.add(Box.createVerticalStrut(6));
        JPanel pRefillTitle = new JPanel(new FlowLayout(0, 0, 0));
        pRefillTitle.add(new JLabel("Refill color maps with selected colors"));
        root.add(pRefillTitle);
        root.add(Box.createVerticalStrut(6));
        JCheckBox cbFF15 = new JCheckBox("$FF15", true);
        JCheckBox cbAUX1 = new JCheckBox("AUX 1", true);
        JCheckBox cbAUX0 = new JCheckBox("AUX 0", true);
        JCheckBox cbFF16 = new JCheckBox("$FF16", true);
        JPanel rowChecks = new JPanel(new GridLayout(1, 4, 12, 6));
        rowChecks.add(cbFF15);
        rowChecks.add(cbAUX1);
        rowChecks.add(cbAUX0);
        rowChecks.add(cbFF16);
        root.add(rowChecks);
        root.add(Box.createVerticalStrut(4));
        JPanel rowSwatches = new JPanel(new GridLayout(1, 4, 12, 6));
        Swatch ff15Sw = new Swatch(chosen[0]);
        Swatch aux1Sw = new Swatch(chosen[1]);
        Swatch aux0Sw = new Swatch(chosen[2]);
        Swatch ff16Sw = new Swatch(chosen[3]);
        rowSwatches.add(ff15Sw);
        rowSwatches.add(aux1Sw);
        rowSwatches.add(aux0Sw);
        rowSwatches.add(ff16Sw);
        root.add(rowSwatches);
        root.add(Box.createVerticalStrut(8));
        JPanel pApply = new JPanel(new FlowLayout(2, 8, 0));
        JButton cancel = new JButton("Cancel");
        JButton apply = new JButton("Apply");
        pApply.add(cancel);
        pApply.add(apply);
        root.add(pApply);
        JDialog dlg = new JDialog(this, "Clear/Fill GFX", true);
        dlg.setContentPane(root);
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        ff15Sw.setOnClick(() -> {
            int sel = PaletteIndexChooser.choose(this, chosen[0]);
            if (sel >= 0) {
                chosen[0] = sel;
                ff15Sw.setIndex(sel);
            }
        });
        aux1Sw.setOnClick(() -> {
            int sel = PaletteIndexChooser.choose(this, chosen[1]);
            if (sel >= 0) {
                chosen[1] = sel;
                aux1Sw.setIndex(sel);
            }
        });
        aux0Sw.setOnClick(() -> {
            int sel = PaletteIndexChooser.choose(this, chosen[2]);
            if (sel >= 0) {
                chosen[2] = sel;
                aux0Sw.setIndex(sel);
            }
        });
        ff16Sw.setOnClick(() -> {
            int sel = PaletteIndexChooser.choose(this, chosen[3]);
            if (sel >= 0) {
                chosen[3] = sel;
                ff16Sw.setIndex(sel);
            }
        });
        no.addActionListener(e -> dlg.dispose());
        yes.addActionListener(e -> {
            this.canvas.pushUndoSnapshot();
            this.updateUndoButtonFromCanvas();
            this.clearGfxAll();
            dlg.dispose();
        });
        cancel.addActionListener(e -> dlg.dispose());
        apply.addActionListener(e -> {
            this.canvas.pushUndoSnapshot();
            this.updateUndoButtonFromCanvas();
            boolean doFF15 = cbFF15.isSelected();
            boolean doAUX1 = cbAUX1.isSelected();
            boolean doAUX0 = cbAUX0.isSelected();
            boolean doFF16 = cbFF16.isSelected();
            this.refillGfxColorMapsSelective(doFF15, doAUX1, doAUX0, doFF16, chosen[0], chosen[1], chosen[2], chosen[3]);
            dlg.dispose();
        });
        dlg.setVisible(true);
    }

    private void doImport(JButton btnUndo) {
        JFileChooser ch = new JFileChooser();
        ch.setDialogTitle("Import DFLI PRG (istvanv layout)");
        if (ch.showOpenDialog(this) == 0) {
            try {
                File f = ch.getSelectedFile();
                this.clearGfxAll();
                PrgImporter.importPRG(this.pic, f);
                this.refreshStatusAndRepaint();
                btnUndo.setText("Undo \u00d7 0");
                btnUndo.setEnabled(false);
                JOptionPane.showMessageDialog(this, "Import OK:\n" + f.getName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Import error: " + ex.getMessage(), "Error", 0);
            }
        }
    }

    private void doExport() {
        JFileChooser chOut = new JFileChooser();
        chOut.setDialogTitle("Save as PRG (.ASM and .PNG will be created alongside)");
        chOut.setSelectedFile(new File("export.prg"));
        if (chOut.showSaveDialog(this) != 0) {
            return;
        }
        File outPrg = chOut.getSelectedFile();
        String baseName = outPrg.getName();
        int dot = baseName.lastIndexOf(46);
        String asmName = (dot > 0 ? baseName.substring(0, dot) : baseName) + ".asm";
        File outAsm = new File(outPrg.getParentFile(), asmName);
        try {
            PrgExporter.exportUsingIoTemplate(this.pic, outPrg, outAsm);
            JOptionPane.showMessageDialog(this, "Export OK:\n" + outPrg.getName() + "\n" + outAsm.getName() + "\n+ 320x200 PNG Bitmap");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Export error: " + ex.getMessage(), "Error", 0);
        }
    }

    private void updateUndoButtonFromCanvas() {
        if (this.btnUndo != null) {
            int left = this.canvas.getUndoCount();
            this.btnUndo.setText("Undo \u00d7 " + left);
            this.btnUndo.setEnabled(left > 0);
        }
    }

    private void clearGfxAll() {
        int x;
        int y;
        for (y = 0; y < 200; ++y) {
            for (x = 0; x < 160; ++x) {
                this.pic.setPixel2bpp(x, y, 0);
            }
        }
        for (y = 0; y < this.pic.getYs(); ++y) {
            this.pic.getFF15Line()[y] = 0;
            this.pic.getFF16Line()[y] = 0;
        }
        for (y = 0; y < 200; ++y) {
            for (x = 0; x < 160; ++x) {
                this.pic.setAuxColorAt(x, y, 0, 0);
                this.pic.setAuxColorAt(x, y, 1, 0);
            }
        }
        this.refreshStatusAndRepaint();
    }

    private void refillGfxColorMapsSelective(boolean doFF15, boolean doAUX1, boolean doAUX0, boolean doFF16, int ff15Idx, int aux1Idx, int aux0Idx, int ff16Idx) {
        int y;
        if (doFF15 || doFF16) {
            for (y = 0; y < this.pic.getYs(); ++y) {
                if (doFF15) {
                    this.pic.getFF15Line()[y] = (byte)(ff15Idx & 0xFF);
                }
                if (!doFF16) continue;
                this.pic.getFF16Line()[y] = (byte)(ff16Idx & 0xFF);
            }
        }
        if (doAUX0 || doAUX1) {
            for (y = 0; y < 200; ++y) {
                for (int x = 0; x < 160; ++x) {
                    if (doAUX0) {
                        this.pic.setAuxColorAt(x, y, 0, aux0Idx & 0xFF);
                    }
                    if (!doAUX1) continue;
                    this.pic.setAuxColorAt(x, y, 1, aux1Idx & 0xFF);
                }
            }
        }
        this.refreshStatusAndRepaint();
    }

    private JButton bigButton(String text) {
        JButton b = new JButton(text);
        b.setFocusPainted(false);
        b.setFont(b.getFont().deriveFont(1, 14.0f));
        b.setPreferredSize(new Dimension(240, 40));
        return b;
    }

    private JComponent makeSectionHeader(String title) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setBorder(new EmptyBorder(6, 0, 4, 0));
        JComponent leftLine = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(110, 110, 110));
                int y = this.getHeight() / 2;
                g.drawLine(0, y, this.getWidth(), y);
            }
        };
        leftLine.setPreferredSize(new Dimension(0, 1));
        JComponent rightLine = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(110, 110, 110));
                int y = this.getHeight() / 2;
                g.drawLine(0, y, this.getWidth(), y);
            }
        };
        rightLine.setPreferredSize(new Dimension(0, 1));
        JLabel lbl = new JLabel(title);
        lbl.setFont(lbl.getFont().deriveFont(1, 15.0f));
        lbl.setBorder(new EmptyBorder(0, 8, 0, 8));
        p.add(leftLine);
        p.add(lbl);
        p.add(rightLine);
        return p;
    }

    private JMenuBar buildMenu() {
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        mb.add(file);
        return mb;
    }

    private void refreshStatusAndRepaint() {
        String heatmapStr = "off";
        if (this.canvas.isHeatmapEnabled()) {
            heatmapStr = String.valueOf(this.pic.getCurrentPaint() & 0xFF);
        }
        this.status.setText(String.format("Curent Rasterline Y=%d  FF15=%02X  FF16=%02X  Paint=%d  aux0Paint=%02X  aux1Paint=%02X  Zoom=%d%%  Heatmap=%s", this.pic.getCurY(), this.pic.getFF15Line()[this.pic.getCurY()] & 0xFF, this.pic.getFF16Line()[this.pic.getCurY()] & 0xFF, this.pic.getCurrentPaint(), this.pic.getColmapPaintIndex2() & 0xFF, this.pic.getColmapPaintIndex3() & 0xFF, this.pic.getZoomPercent(), heatmapStr));
        this.palette.repaint();
        this.paintPanel.repaint();
        this.canvas.repaint();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new DFLIEditor().setVisible(true));
    }

    private static class Labeled
    extends JPanel {
        Labeled(String title, JComponent inner) {
            super(new BorderLayout(6, 0));
            this.add((Component)new JLabel(title + ": "), "West");
            this.add((Component)inner, "Center");
        }
    }

    static class Swatch
    extends JPanel {
        private int index;
        private Runnable onClick;

        Swatch(int idx) {
            this.setPreferredSize(new Dimension(40, 24));
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            this.setIndex(idx);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (onClick != null) {
                        onClick.run();
                    }
                }
            });
            this.setToolTipText("Click to choose color\u2026");
        }

        void setOnClick(Runnable r) {
            this.onClick = r;
        }

        void setIndex(int idx) {
            this.index = idx & 0xFF;
            this.setBackground(Plus4Palette.getColor(this.index));
            this.repaint();
        }

        int getIndex() {
            return this.index;
        }
    }

    static class PaletteIndexChooser {
        PaletteIndexChooser() {
        }

        static int choose(Window parent, int initialIndex) {
            final JDialog dlg = new JDialog(parent, "Choose Plus/4 color", Dialog.ModalityType.APPLICATION_MODAL);
            JPanel grid = new JPanel(new GridLayout(8, 16, 2, 2));
            grid.setBorder(new EmptyBorder(8, 8, 8, 8));
            final int[] result = new int[]{-1};
            int total = Plus4Palette.size();
            int i = 0;
            while (i < total) {
                JPanel cell = new JPanel();
                cell.setBackground(Plus4Palette.getColor(i));
                cell.setPreferredSize(new Dimension(22, 18));
                cell.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
                final int idx = i++;
                cell.setToolTipText(String.format("#%d (0x%02X)", idx, idx));
                cell.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        result[0] = idx;
                        dlg.dispose();
                    }
                });
                grid.add(cell);
            }
            JPanel south = new JPanel(new FlowLayout(2, 8, 8));
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(e -> {
                result[0] = -1;
                dlg.dispose();
            });
            south.add(cancel);
            dlg.setLayout(new BorderLayout());
            dlg.add((Component)grid, "Center");
            dlg.add((Component)south, "South");
            dlg.pack();
            dlg.setLocationRelativeTo(parent);
            dlg.setVisible(true);
            return result[0];
        }
    }

    static class ColCell {
        final JPanel panel = new JPanel();
        final JCheckBox ckA0 = new JCheckBox("A0", true);
        final JCheckBox ckA1 = new JCheckBox("A1", true);
        final SwatchHex swAux0;
        final SwatchHex swAux1;

        ColCell(int col, int a0, int a1) {
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.setBorder(new EmptyBorder(4, 4, 4, 4));
            JLabel lab = new JLabel(String.valueOf(col));
            lab.setAlignmentX(0.0f);
            this.panel.add(lab);
            this.panel.add(Box.createVerticalStrut(4));
            this.swAux0 = new SwatchHex(a0);
            this.swAux1 = new SwatchHex(a1);
            this.swAux0.sw.setToolTipText("AUX0 $" + String.format("%02X", a0 & 0xFF));
            this.swAux1.sw.setToolTipText("AUX1 $" + String.format("%02X", a1 & 0xFF));
            JPanel r0 = new JPanel(new FlowLayout(0, 4, 0));
            r0.add(this.ckA0);
            r0.add(this.swAux0.panel);
            JPanel r1 = new JPanel(new FlowLayout(0, 4, 0));
            r1.add(this.ckA1);
            r1.add(this.swAux1.panel);
            r0.setAlignmentX(0.0f);
            r1.setAlignmentX(0.0f);
            this.panel.add(r0);
            this.panel.add(r1);
        }
    }

    static class SwatchHex {
        final JPanel panel = new JPanel(new BorderLayout(6, 0));
        final Swatch sw;
        final JLabel hex = new JLabel();

        SwatchHex(int idx) {
            this.sw = new Swatch(idx);
            this.hex.setText(String.format("$%02X", idx & 0xFF));
            this.panel.add((Component)this.sw, "West");
            this.panel.add((Component)this.hex, "Center");
        }

        void setOnClick(Runnable r) {
            this.sw.setOnClick(() -> {
                r.run();
                this.hex.setText(String.format("$%02X", this.sw.getIndex() & 0xFF));
            });
        }

        void setIndex(int idx) {
            this.sw.setIndex(idx);
            this.hex.setText(String.format("$%02X", this.sw.getIndex() & 0xFF));
        }

        int getIndex() {
            return this.sw.getIndex();
        }
    }
}

