/*
 * Decompiled with CFR 0.152.
 */
package com.medfli.ui;

import com.medfli.model.PictureInfo;
import com.medfli.model.Plus4Palette;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class PalettePanel
extends JPanel {
    private static final int COLS = 16;
    private static final int ROWS = 8;
    private static final int CELL_W = 42;
    private static final int CELL_H = 39;
    private final PictureInfo pic;
    private final Runnable onChange;

    public PalettePanel(final PictureInfo pic, final Runnable onChange) {
        this.pic = pic;
        this.onChange = onChange;
        this.setPreferredSize(new Dimension(672, 312));
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(1000);
        this.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                int x = e.getX() / 42;
                int y = e.getY() / 39;
                if (x < 0 || x >= 16 || y < 0 || y >= 8) {
                    return;
                }
                int index = y * 16 + x;
                if (index >= Plus4Palette.size()) {
                    return;
                }
                int ovr = pic.getOverridePaintIndex();
                if (ovr != -1 && SwingUtilities.isLeftMouseButton(e)) {
                    switch (ovr) {
                        case 0: {
                            pic.getFF15Line()[pic.getCurY()] = (byte)index;
                            break;
                        }
                        case 1: {
                            pic.setColmapPaintIndex3(index);
                            break;
                        }
                        case 2: {
                            pic.setColmapPaintIndex2(index);
                            break;
                        }
                        case 3: {
                            pic.getFF16Line()[pic.getCurY()] = (byte)index;
                        }
                    }
                    if (onChange != null) {
                        onChange.run();
                    }
                    return;
                }
                int paint = pic.getCurrentPaint();
                if (SwingUtilities.isLeftMouseButton(e)) {
                    switch (paint) {
                        case 0: {
                            pic.getFF15Line()[pic.getCurY()] = (byte)index;
                            break;
                        }
                        case 1: {
                            pic.setColmapPaintIndex3(index);
                            break;
                        }
                        case 2: {
                            pic.setColmapPaintIndex2(index);
                            break;
                        }
                        case 3: {
                            pic.getFF16Line()[pic.getCurY()] = (byte)index;
                        }
                    }
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    pic.getFF16Line()[pic.getCurY()] = (byte)index;
                }
                if (onChange != null) {
                    onChange.run();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getX() / 42;
                int y = e.getY() / 39;
                if (x < 0 || x >= 16 || y < 0 || y >= 8) {
                    PalettePanel.this.setToolTipText(null);
                    return;
                }
                int index = y * 16 + x;
                if (index < 0 || index >= Plus4Palette.size()) {
                    PalettePanel.this.setToolTipText(null);
                    return;
                }
                PalettePanel.this.setToolTipText(String.format("$%02X", index & 0xFF));
            }
        });
        InputMap im = this.getInputMap(2);
        ActionMap am = this.getActionMap();
        for (int k = 48; k <= 51; ++k) {
            final int idx = k - 48;
            im.put(KeyStroke.getKeyStroke("pressed " + (char)k), "ovr_on_" + idx);
            im.put(KeyStroke.getKeyStroke("released " + (char)k), "ovr_off_" + idx);
            am.put("ovr_on_" + idx, new AbstractAction(this){
                final /* synthetic */ PalettePanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    pic.setOverridePaintIndex(idx);
                }
            });
            am.put("ovr_off_" + idx, new AbstractAction(this){
                final /* synthetic */ PalettePanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (pic.getOverridePaintIndex() == idx) {
                        pic.setOverridePaintIndex(-1);
                    }
                }
            });
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int cur = this.pic.getCurY();
        int sel0 = this.pic.getFF15Line()[cur] & 0xFF;
        int sel1 = this.pic.getColmapPaintIndex3() & 0xFF;
        int sel2 = this.pic.getColmapPaintIndex2() & 0xFF;
        int sel3 = this.pic.getFF16Line()[cur] & 0xFF;
        Font base = g.getFont().deriveFont(1, 12.0f);
        g.setFont(base);
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 16; ++x) {
                String marks;
                int idx = y * 16 + x;
                if (idx >= Plus4Palette.size()) continue;
                Color c = Plus4Palette.getColor(idx);
                int px = x * 42;
                int py = y * 39;
                g.setColor(c);
                g.fillRect(px, py, 42, 39);
                StringBuilder sb = new StringBuilder();
                if (idx == sel0) {
                    sb.append('0');
                }
                if (idx == sel1) {
                    sb.append('1');
                }
                if (idx == sel2) {
                    sb.append('2');
                }
                if (idx == sel3) {
                    sb.append('3');
                }
                if (!(marks = sb.toString()).isEmpty()) {
                    String spaced = marks.replaceAll("", " ").trim();
                    if (marks.length() <= 2) {
                        int tx = px + 6;
                        int ty = py + 19 + 4;
                        g.setColor(Color.BLACK);
                        g.drawString(spaced, tx, ty);
                        g.setColor(Color.WHITE);
                        g.drawString(spaced, tx + 1, ty + 1);
                    } else {
                        StringBuilder t = new StringBuilder();
                        StringBuilder b = new StringBuilder();
                        for (int i = 0; i < marks.length(); ++i) {
                            (i < 2 ? t : b).append(marks.charAt(i)).append(' ');
                        }
                        int tx = px + 6;
                        int ty1 = py + 19 - 3;
                        int ty2 = py + 19 + 13;
                        g.setColor(Color.BLACK);
                        g.drawString(t.toString().trim(), tx, ty1);
                        g.setColor(Color.WHITE);
                        g.drawString(t.toString().trim(), tx + 1, ty1 + 1);
                        g.setColor(Color.BLACK);
                        g.drawString(b.toString().trim(), tx, ty2);
                        g.setColor(Color.WHITE);
                        g.drawString(b.toString().trim(), tx + 1, ty2 + 1);
                    }
                }
                g.setColor(Color.DARK_GRAY);
                g.drawRect(px, py, 42, 39);
            }
        }
    }
}

